--[[ Loads up a slew of objects to load into the screen, like how 3.9 does. I prefer to keep these optional, incase another screen wants to hide these elements.
--]]


local t = Def.ActorFrame {};


t[#t+1] = StandardDecorationFromFileOptional("Header","Header");


t[#t+1] = StandardDecorationFromFileOptional("Footer","Footer");
t[#t+1] = StandardDecorationFromFileOptional("bart","bart");

t[#t+1] = StandardDecorationFromFileOptional("StyleIcon","StyleIcon");

t[#t+1] = StandardDecorationFromFileOptional( "Help", "Help" );

t[#t+1] = StandardDecorationFromFileOptional( "GrooveRadar", "GrooveRadar" );

t[#t+1] = StandardDecorationFromFileOptional("StageDisplay","StageDisplay");

t[#t+1] = StandardDecorationFromFileOptional("StepsDisplayList","StepsDisplayList");

--[[
t[#t+1] = StandardDecorationFromFileOptional("PercentageScore","PercentageScore");
--]]

t[#t+1] = StandardDecorationFromFile("BPMDisplay","BPMDisplay");

--[[
t[#t+1] = Def.ActorFrame {

LoadActor( "Testpic" )..{
		OnCommand=cmd(Center);
		OffCommand=cmd(diffusealpha,0);
		
	};
}
--]]

local function PercentScore(pn)
	local t = LoadFont("ScoreDisplay2")..{
		InitCommand=cmd(draworder,600;zoom,0.625;shadowlength,1);
		BeginCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			local SongOrCourse, StepsOrTrail;
			if GAMESTATE:IsCourseMode() then
				SongOrCourse = GAMESTATE:GetCurrentCourse();
				StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
			else
				SongOrCourse = GAMESTATE:GetCurrentSong();
				StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
			end;

			local profile, scorelist;
			local text = "";
			if SongOrCourse and StepsOrTrail then
				local st = StepsOrTrail:GetStepsType();
				local diff = StepsOrTrail:GetDifficulty();
				local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
				local cd = GetCustomDifficulty(st, diff, courseType);
				self:diffuse(CustomDifficultyToColor(cd));
				self:shadowcolor(CustomDifficultyToDarkColor(cd));

				if PROFILEMAN:IsPersistentProfile(pn) then
					-- player profile
					profile = PROFILEMAN:GetProfile(pn);
				else
					-- machine profile
					profile = PROFILEMAN:GetMachineProfile();
				end;

				scorelist = profile:GetHighScoreList(SongOrCourse,StepsOrTrail);
				assert(scorelist)
				local scores = scorelist:GetHighScores();
				local topscore = scores[1];
				if topscore then
					text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
					-- 100% hack
					if text == "100.00%" then
						text = "100.00%";
					end;
				else
					text = string.format("%.2f%%", 0);
				end;
			else
				text = "";
			end;
			self:settext(text);
		end;
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	};

	if pn == PLAYER_1 then
		t.CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
		t.CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
	else
		t.CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
		t.CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
	end

	return t;
end


for pn in ivalues(PlayerNumber) do
	
	if ShowStandardDecoration("PercentScore"..ToEnumShortString(pn)) then
		t[#t+1] = StandardDecorationFromTable("PercentScore"..ToEnumShortString(pn), PercentScore(pn));
	end;
end


local function GetDifListY(d)
	local r=0;
	if d == "Difficulty_Beginner" then
		r=(15*0);
	elseif d == "Difficulty_Easy" then
		r=(15*1);
	elseif d == "Difficulty_Medium" then
		r=(15*2);
	elseif d == "Difficulty_Hard" then
		r=(15*3);
	elseif d == "Difficulty_Challenge" then
		r=(15*4);
	elseif d == "Difficulty_Edit" then
		r=(15*5);
	end;
	return r;
end;

----iܰʰ|-----
local function GetFlexDifListY(d, st, song)
	local r=0;
	local b=0;
	if d == "Difficulty_Beginner" then
		r=(15*0);
	elseif d == "Difficulty_Easy" then
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Beginner") then
			b=b+1;
		end;
		r=(15*b);
	elseif d == "Difficulty_Medium" then
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Beginner") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Easy") then
			b=b+1;
		end;
		r=(15*b);
	elseif d == "Difficulty_Hard" then
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Beginner") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Easy") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Medium") then
			b=b+1;
		end;
		r=(15*b);
	elseif d == "Difficulty_Challenge" then
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Beginner") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Easy") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Medium") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Hard") then
			b=b+1;
		end;
		r=(15*b);
	elseif d == "Difficulty_Edit" then
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Beginner") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Easy") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Medium") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Hard") then
			b=b+1;
		end;
		if song:HasStepsTypeAndDifficulty(st,"Difficulty_Challenge") then
			b=b+1;
		end;
		r=(15*b);
	end;
	return r;
end;


local function GetDifListX(self,pn,offset,fade)
	if pn==PLAYER_1 then
		--self:horizalign(left);
		self:x(SCREEN_LEFT+174-offset);
		if fade>0 then
			self:faderight(fade);
		end;
	else
		--self:horizalign(right);
		self:x(SCREEN_LEFT+174+offset);
		if fade>0 then
			self:fadeleft(fade);
		end;
	end;
	return r;
end;

local wid = 131

local function DrawDifList(pn,diff)
	local t = Def.ActorFrame {
		InitCommand=cmd(player,pn;y,SCREEN_CENTER_Y+93;addy,900;sleep,0.5;linear,0.05;addy,-900;);
		--full combo

		LoadActor(THEME:GetPathG("Player","Badge FullCombo"))..{

			InitCommand=cmd(shadowlength,1;zoom,0);
			BeginCommand=cmd(playcommand,"Set");
			OffCommand=cmd(decelerate,0.05;diffusealpha,0;);
			SetCommand=function(self)
				local st=GAMESTATE:GetCurrentStyle():GetStepsType();
				local song=GAMESTATE:GetCurrentSong();
			if song then
				GetDifListX(self,pn,wid,0);
				self:addx(11);
				self:y(GetFlexDifListY(diff, st, song)-3);
				if song:HasStepsTypeAndDifficulty(st,diff) then
					local steps = song:GetOneSteps( st, diff );
					if PROFILEMAN:IsPersistentProfile(pn) then
						-- player profile
						profile = PROFILEMAN:GetProfile(pn);
					else
						-- machine profile
						profile = PROFILEMAN:GetMachineProfile();
					end;
					scorelist = profile:GetHighScoreList(song,steps);
					assert(scorelist);
					local scores = scorelist:GetHighScores();
					assert(scores);
					local topscore;

					if scores[1] then
						topscore = scores[1];
						assert(topscore);
						local misses = topscore:GetTapNoteScore("TapNoteScore_Miss")+topscore:GetTapNoteScore("TapNoteScore_CheckpointMiss")
						local boos = topscore:GetTapNoteScore("TapNoteScore_W5")
						local goods = topscore:GetTapNoteScore("TapNoteScore_W4")
						local greats = topscore:GetTapNoteScore("TapNoteScore_W3")
						local perfects = topscore:GetTapNoteScore("TapNoteScore_W2")
						local marvelous = topscore:GetTapNoteScore("TapNoteScore_W1")
						if (misses+boos+goods) == 0 and scores[1]:GetScore() > 0 and (marvelous+perfects)>0 then
							if (greats+perfects) == 0 then

								self:diffuse(color("#ffffee"));
								self:glowblink();
								self:effectperiod(0.20);
								self:zoom(0.25);
							elseif greats == 0 then
								self:diffuse(color("#fafc3e"));
								self:glowshift();
								self:zoom(0.25);
							else
								self:diffuse(color("#06fd32"));
								self:stopeffect();
								self:zoom(0.25);
							end;
							self:diffusealpha(0.8);
						else 
							self:diffusealpha(0);
						end;
					else
						self:diffusealpha(0);
					end;

					
					
				else
					self:diffusealpha(0);
				end;
			end;
		end;
			CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
			CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");

		};

		Def.Quad{
			InitCommand=cmd(shadowlength,1;zoom,0.18;);
			BeginCommand=cmd(playcommand,"Set");
			OffCommand=cmd(decelerate,0.05;diffusealpha,0;);
			SetCommand=function(self)
				local st=GAMESTATE:GetCurrentStyle():GetStepsType();
				local song=GAMESTATE:GetCurrentSong();
		if song then
				GetDifListX(self,pn,wid,0);
				self:y(GetFlexDifListY(diff, st, song));
				if song:HasStepsTypeAndDifficulty(st,diff) then
					local steps = song:GetOneSteps( st, diff );

					if PROFILEMAN:IsPersistentProfile(pn) then

						-- player profile
						profile = PROFILEMAN:GetProfile(pn);
					else
						-- machine profile
						profile = PROFILEMAN:GetMachineProfile();
					end;

					local scorelist = profile:GetHighScoreList(song,steps);
					assert(scorelist);
					local scores = scorelist:GetHighScores();
					assert(scores);
					local topgrade;

					if scores[1] then
						topgrade = scores[1]:GetGrade();
						assert(topgrade);
						if scores[1]:GetScore()>1  then

							if scores[1]:GetScore()==1000000 and topgrade=="Grade_Tier17" then --AutoPlayHack
								self:LoadBackground(THEME:GetPathG("myMusicWheel","Tier01"));
								self:diffusealpha(1);

							else --Normal
								self:LoadBackground(THEME:GetPathG("myMusicWheel",ToEnumShortString(topgrade)));
								self:diffusealpha(1);
							end;
						else
							self:diffusealpha(0);
						end;

					else
						self:diffusealpha(0);
					end;
				else
					self:diffusealpha(0);
				end;
			end;
		end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");

		};
	};
	return t;
end;
---[[
if  not GAMESTATE:IsCourseMode() then

	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Beginner');
	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Easy');
	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Medium');
	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Hard');
	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Challenge');
	t[#t+1]=DrawDifList(PLAYER_1,'Difficulty_Edit');

	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Beginner');
	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Easy');
	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Medium');
	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Hard');
	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Challenge');
	t[#t+1]=DrawDifList(PLAYER_2,'Difficulty_Edit');
	
	
end;

--]]

--[[
local song=GAMESTATE:GetCurrentSong();
t[#t+1] = Def.ActorFrame {
	LoadFont( "Adams" )..{
	InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;settext,song);
	};
}
--]]


return t